<?php $__env->startSection('contenido'); ?>
    <div class="main-content app-content">

        <!-- container -->
        <div class="main-container container-fluid">

            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Usuarios</span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="<?php echo e(route('roles.index')); ?>">Usuarios</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Ver Usuarios</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->


            <!-- row -->
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row" style="align-items: center;
                            justify-content: center;">
                               <h6 class="main-content-label mb-1">Listado de Usuarios </h6>
                                <a href="<?php echo e(route('usuarios.create')); ?>" style="float: right;"><button class="btn btn-primary">Crear Nuevo</button></a>
                            </div>
                            <div class="table-responsive  export-table">
                                <table id="file-datatable"
                                    class="table table-bordered text-nowrap key-buttons border-bottom">
                                    <thead>
                                        <tr>
                                            <th class="border-bottom-0">id</th>
                                            <th class="border-bottom-0">Nombre</th>
                                            <th class="border-bottom-0">Roles</th>
                                            <th class="border-bottom-0">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!$user->getRoleNames()->contains('Cliente')): ?>
                                            <tr>
                                                <td><?php echo e($user->id); ?></td>
                                                <td><?php echo e($user->name); ?></td>
                                                <td>
                                                    <?php $__currentLoopData = $user->getRoleNames(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($role); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Eliminar Usuario')): ?>
                                                        <button title="Eliminar" class="btn btn-danger waves-effect waves-light"
                                                            onclick="deleteConfirm(<?php echo e($user->id); ?>)"><i
                                                                class="bx bx-trash-alt" style="font-size: 20px"></i></button>
                                                    <?php endif; ?>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Editar Usuario')): ?>
                                                        <a title="Editar" class="btn btn-warning waves-effect waves-light"
                                                            href="<?php echo e(route('usuarios.edit', $user->id)); ?>"><i class="bx bx-pencil"
                                                                style="font-size: 20px"></i></a>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- row -->


        </div>
        <!-- Container closed -->
    </div>

    <script>
        function deleteConfirm(id) {
            Swal.fire({
                title: "Seguro que desea ocultar este rol?"
                , icon: "warning"
                , showCancelButton: !0
                , confirmButtonColor: "#34c38f"
                , cancelButtonColor: "#f46a6a"
                , confirmButtonText: "Si"
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#formDelete").attr('action', '<?php echo e(url("usuarios/")); ?>' + '/' + id);
                    $("#formDelete").submit();
                }

            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-independiente'); ?>
    <?php echo $__env->make('layouts.js-dattable', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home1/dosbyte1/catalogos.dosbytes-host.com/resources/views/usuarios/index.blade.php ENDPATH**/ ?>