@extends('layouts.app')
@section('contenido')
    <div class="main-content app-content">

        <!-- container -->
        <div class="main-container container-fluid">

            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Perfil de Usuario</span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="{{ url('/home') }}">Usuario</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Ver Perfil</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->
            <!-- row -->
            <div class="row">
                <div class="col-xl-4">
                    <div class="card  bg-soft">
                        <div>
                            <div class="row">
                                <div class="col-7">
                                    <div class="text-primary p-3">
                                        <h5 class="text-primary">{{ Auth::user()->name }} {{ Auth::user()->apellido }}</h5>
                                        <p>{{ Auth::user()->email }}</p>
                                        <ul class="ps-3 mb-0">
                                            @foreach (Auth::user()->getRoleNames() as $role)
                                                 <li class="py-1">{{ $role }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                                <div class="col-5 align-self-end">
                                    <img src=" {{ isset(Auth::user()->avatar) ? asset(Auth::user()->avatar) : asset('assets/iconfonts/ionicons/ionicons/svg/ios-person.svg') }}" alt="" class="rounded-circle header-profile-user" style="    height: 119px;
                                    width: 120px;">
                                    <center>
                                        <input onclick="document.getElementById('input_avatar').click();" class="btn btn-primary" type="button"  value="Cambiar" style="margin-top: 5px">
                                    </center>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <form style="display: none" action="{{route('usuarios-cambiar-avatar')}}" enctype="multipart/form-data" method="post" id="form_avatar">
                    @csrf
                    <input type="file" name="avatar" id="input_avatar" onchange="document.getElementById('form_avatar').submit()">
                 </form>
                <div class="col-xl-8">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-3">
                                        <div class="avatar-xs me-3">
                                            <span class="avatar-title rounded-circle bg-primary bg-soft text-primary font-size-18">

                                            </span>
                                        </div>
                                        <h5 class="font-size-14 mb-0">Cambiar Contraseña</h5>
                                    </div>
                                    <div class="text-muted mt-4">
                                      <form action="{{ route('usuarios-cambiar-pass') }}" method="POST">
                                        @csrf
                                        <div class="mb-3 row">
                                            <label for="example-password-input" class="col-md-2 col-form-label">Nueva Contraseña</label>
                                            <div class="col-md-10">
                                                <input class="form-control" type="password"  placeholder="Introduzca la contraseña" id="password" name="password" required>
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <label for="example-password-input" class="col-md-2 col-form-label">Confirmar Contraseña</label>
                                            <div class="col-md-10">
                                                <input class="form-control" type="password"  placeholder="Introduzca la contraseña" id="confirm_password" name="confirm_password" required>
                                            </div>
                                        </div>
                                        <div class="mb-3 row">
                                            <div  style="text-align: -webkit-right;">

                                                <div class="col-md-6">
                                                    <input class="btn btn-primary" type="submit"  value="Cambiar">
                                                </div>
                                            </div>
                                        </div>
                                      </form>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                    <!-- end row -->
                </div>
            </div>
            <!-- row -->


        </div>
        <!-- Container closed -->
    </div>

    <script>
        function deleteConfirm(id) {
            Swal.fire({
                title: "Seguro que desea ocultar este rol?"
                , icon: "warning"
                , showCancelButton: !0
                , confirmButtonColor: "#34c38f"
                , cancelButtonColor: "#f46a6a"
                , confirmButtonText: "Si"
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#formDelete").attr('action', '{{ url("usuarios/") }}' + '/' + id);
                    $("#formDelete").submit();
                }

            });
        }

    </script>
@endsection

@section('js-independiente')
    @include('layouts.js-dattable')
@endsection
