@extends('layouts.app')
@section('contenido')
    <div class="main-content app-content">

        <!-- container -->
        <div class="main-container container-fluid">

            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Usuarios</span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="{{ route('roles.index') }}">Usuarios</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Ver Usuarios</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->


            <!-- row -->
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row" style="align-items: center;
                            justify-content: center;">
                               <h6 class="main-content-label mb-1">Listado de Usuarios </h6>
                                <a href="{{route('usuarios.create')}}" style="float: right;"><button class="btn btn-primary">Crear Nuevo</button></a>
                            </div>
                            <div class="table-responsive  export-table">
                                <table id="file-datatable"
                                    class="table table-bordered text-nowrap key-buttons border-bottom">
                                    <thead>
                                        <tr>
                                            <th class="border-bottom-0">id</th>
                                            <th class="border-bottom-0">Nombre</th>
                                            <th class="border-bottom-0">Roles</th>
                                            <th class="border-bottom-0">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($users as $user)
                                        @if(!$user->getRoleNames()->contains('Cliente'))
                                            <tr>
                                                <td>{{ $user->id }}</td>
                                                <td>{{ $user->name }}</td>
                                                <td>
                                                    @foreach ($user->getRoleNames() as $role)
                                                        <li>{{ $role }}</li>
                                                    @endforeach
                                                </td>
                                                <td>
                                                    @can('Eliminar Usuario')
                                                        <button title="Eliminar" class="btn btn-danger waves-effect waves-light"
                                                            onclick="deleteConfirm({{ $user->id }})"><i
                                                                class="bx bx-trash-alt" style="font-size: 20px"></i></button>
                                                    @endcan
                                                    @can('Editar Usuario')
                                                        <a title="Editar" class="btn btn-warning waves-effect waves-light"
                                                            href="{{ route('usuarios.edit', $user->id) }}"><i class="bx bx-pencil"
                                                                style="font-size: 20px"></i></a>
                                                    @endcan
                                                </td>
                                            </tr>
                                            @endif
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- row -->


        </div>
        <!-- Container closed -->
    </div>

    <script>
        function deleteConfirm(id) {
            Swal.fire({
                title: "Seguro que desea ocultar este rol?"
                , icon: "warning"
                , showCancelButton: !0
                , confirmButtonColor: "#34c38f"
                , cancelButtonColor: "#f46a6a"
                , confirmButtonText: "Si"
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#formDelete").attr('action', '{{ url("usuarios/") }}' + '/' + id);
                    $("#formDelete").submit();
                }

            });
        }

    </script>
@endsection

@section('js-independiente')
    @include('layouts.js-dattable')
@endsection
