@extends('layouts.app')
@section('contenido')
    <div class="main-content app-content">

        <!-- container -->
        <div class="main-container container-fluid">

            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Nuevo Usuario </span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="javascript:void(0);">Usuarios</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Nuevo Usuario</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->
            <!-- row -->
            <div class="row row-sm">
                <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                    <div class="card  box-shadow-0">
                        <div class="card-header">
                            <h4 class="card-title mb-1">Crear Usuario </h4>
                        </div>
                        <div class="card-body pt-0">
                            <form id="formulario"  action="{{ route('usuarios.store') }}" method="post"  enctype="multipart/form-data">
                                @csrf
                                 <div class="mb-3 row">
                                     <label for="example-text-input" class="col-md-2 col-form-label">Nombre</label>
                                     <div class="col-md-10">
                                         <input class="form-control" type="text"  id="name" name="name" placeholder="Introduzca el Nombre" required>
                                     </div>
                                 </div>
                                 <div class="mb-3 row">
                                     <label for="example-search-input" class="col-md-2 col-form-label">Apellido</label>
                                     <div class="col-md-10">
                                         <input class="form-control" type="text" id="apellido" name="apellido" placeholder="Introduzca el Apellido" required>
                                     </div>
                                 </div>
                                 <div class="mb-3 row">
                                     <label for="example-email-input" class="col-md-2 col-form-label">Correo</label>
                                     <div class="col-md-10">
                                         <input class="form-control" type="email"  placeholder="Introduzca el Correo" name="email" id="email" required>
                                     </div>
                                 </div>
                                <div class="mb-3 row">
                                     <label for="example-password-input" class="col-md-2 col-form-label">Contraseña</label>
                                     <div class="col-md-10">
                                         <input class="form-control" type="password"  placeholder="Introduzca la contraseña" id="pass" name="password" required>
                                     </div>
                                 </div>
                                 <div class="mb-3 row">
                                     <label for="example-password-input" class="col-md-2 col-form-label">Confirmar Contraseña</label>
                                     <div class="col-md-10">
                                         <input class="form-control" type="password"  placeholder="Introduzca la contraseña" id="confirm_password" name="confirm_password" required>
                                     </div>
                                 </div>
                                 {{--  <div class="mb-3 row">
                                     <label for="example-password-input" class="col-md-2 col-form-label">Avatar</label>
                                     <div class="col-md-10">
                                         <input class="form-control" type="file"  placeholder="Introduzca la contraseña" id="vatar" name="avatar" >
                                     </div>
                                 </div>  --}}
                                 <div class="mb-3 row">
                                     <label class="col-md-2 col-form-label">Roles</label>
                                     <div class="col-md-10">
                                         <select class="form-select js-example-basic-single" name="roles"  >
                                            @foreach ($roles as $rol)
                                                <option value="{{ $rol }}">{{ $rol }}</option>
                                            @endforeach
                                         </select>
                                     </div>
                                 </div>

                                 <div class="mb-3 row">
                                     <div  style="display: flex">
                                         <div class="col-md-6">
                                             <a href="{{ route('usuarios.index') }}" style="width: 100%"  type="button" class="btn btn-danger waves-effect waves-light">Atras</a>
                                         </div>
                                         <div class="col-md-6">
                                             <input class="form-control btn btn-success waves-effect waves-light" type="submit"  value="Guardar">
                                         </div>
                                     </div>
                                 </div>
                             </form>
                        </div>
                    </div>
                </div>

            </div>
            <!-- row -->

        </div>
        <!-- Container closed -->
    </div>
@endsection

@section('js-independiente')
    @include('layouts.js-fomularios')
@endsection
