@extends('layouts.app')
@section('contenido')
<div class="main-content app-content">

    <!-- container -->
    <div class="main-container container-fluid">

        <!-- breadcrumb -->
        <div class="breadcrumb-header justify-content-between">
            <div class="left-content">
              <span class="main-content-title mg-b-0 mg-b-lg-1">Roles</span>
            </div>
            <div class="justify-content-center mt-2">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item tx-15"><a href="{{route('roles.index')}}">Roles</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Ver Roles</li>
                </ol>
            </div>
        </div>
        <!-- /breadcrumb -->


        <!-- row -->
        <div class="row row-sm">
            <div class="col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row" style="align-items: center;
                        justify-content: center;">
                           <h6 class="main-content-label mb-1">Listado de roles </h6>
                            <a href="{{route('roles.create')}}" style="float: right;"><button class="btn btn-primary">Crear Nuevo</button></a>
                        </div>
                        <div class="table-responsive  export-table">

                            <table id="file-datatable" class="table table-bordered text-nowrap key-buttons border-bottom">
                                <thead>
                                    <tr>
                                        <th class="border-bottom-0">id</th>
                                        <th class="border-bottom-0">Nombre</th>
                                        <th class="border-bottom-0">Permisos</th>
                                        <th class="border-bottom-0">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach ($roles as $rol)
                                    <tr>
                                        <td>{{$rol->id}}</td>
                                        <td>{{ $rol->name }}</td>
                                        <td>@if($rol->name == 'Super Admin')
                                            <p>Maximo usuario, contiene todos los permisos existentes</p>
                                            @else
                                            <ul>
                                                 @foreach ($rol->permissions as $per)
                                            <li>
                                                {{ $per->name }}
                                            </li>
                                        @endforeach
                                            </ul>
                                        @endif
                                        </td>
                                        <td>
                                            <button title="Eliminar" class="btn btn-danger waves-effect waves-light" onclick="deleteConfirm({{ $rol->id }})"><i  class="bx bx-trash-alt" style="font-size: 20px"></i></button>

                                             <a title="Editar" class="btn btn-warning waves-effect waves-light"  href="{{ route('roles.edit',$rol->id) }}"><i  class="bx bx-pencil" style="font-size: 20px"></i></a>
                                            </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       <!-- row -->


    </div>
    <!-- Container closed -->
</div>

<script>
    function deleteConfirm(id) {
        Swal.fire({
            title: "Seguro que desea ocultar este rol?"
            , icon: "warning"
            , showCancelButton: !0
            , confirmButtonColor: "#34c38f"
            , cancelButtonColor: "#f46a6a"
            , confirmButtonText: "Si"
        }).then((result) => {
            if (result.isConfirmed) {
                $("#formDelete").attr('action', '{{ url("roles/") }}' + '/' + id);
                $("#formDelete").submit();
            }

        });
    }

</script>
@endsection

@section('js-independiente')
@include('layouts.js-dattable')

@endsection
