@extends('layouts.app')
@section('contenido')
    <div class="main-content app-content">

        <!-- container -->
        <div class="main-container container-fluid">

            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Editar Rol </span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="javascript:void(0);">Roles</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Editar rol</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->
            <!-- row -->
            <div class="row row-sm">
                <div class="col-lg-12 col-xl-12 col-md-12 col-sm-12">
                    <div class="card  box-shadow-0">
                        <div class="card-header">
                            <h4 class="card-title mb-1">Editar Rol </h4>
                        </div>
                        <div class="card-body pt-0">
                            <form action="{{ route('roles.update', $role->id) }}" method="post" name="f1">
                                @csrf
                                @method('PUT')
                                <div class="mb-3 row">
                                    <label for="example-text-input" class="col-md-2 col-form-label">Nombre</label>
                                    <div class="col-md-10">
                                        <input class="form-control" value="{{ $role->name }}" type="text"
                                            id="name" name="name" placeholder="Introduzca el Nombre" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <label class="col-md-12 col-form-label">Permisos</label>
                                    @php
                                        $primero = true;
                                    @endphp
                                    <div class="col-md-12">
                                        <center>
                                            <input type="checkbox" onchange="seleccionarTodo()" id="selecAll">
                                            <script>
                                                function seleccionarTodo() {
                                                    for (let i = 0; i < document.f1.elements.length; i++) {
                                                        if (document.f1.elements[i].type === "checkbox") {
                                                            document.f1.elements[i].checked = !document.f1.elements[i].checked;
                                                        }
                                                    }
                                                    document.getElementById('selecAll').checked = !document.getElementById('selecAll').checked;
                                                }
                                            </script>
                                            <label style="font-size: 20px">Seleccionar Todos</label>
                                        </center>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <br><br>
                                            <h3>Roles</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_roles as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"
                                                            @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="col-12">
                                            <br><br>
                                            <h3>Usuarios</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_user as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"
                                                            @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <h3>Proyectos</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_proyecto as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Clientes</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_cliente as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Lotes</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_lote as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Contratos</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_contrato as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Recibos</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_recibo as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Configuracion</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_config as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Cotizacion</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_cotizacion as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Estadisticas</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_estadisticas as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Gastos</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_gasto as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Ingresos</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_ingreso as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>

                                        <div class="col-12">
                                            <h3>Marketing</h3>
                                            <hr>
                                            <div class="row">
                                                @foreach ($p_marketing as $per)
                                                    <div class="col-md-3">
                                                        <input type="checkbox" name="permission[]" id="{{ $per->id }}"
                                                            value="{{ $per->name }}"    @if ($role->permissions->contains($per)) checked @endif>
                                                        <label for="{{ $per->id }}">{{ $per->name }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <br><br>
                                        </div>


                                        <br><br>
                                    </div>
                                </div>
                                <br><br>
                                <div class="col-12">
                                    <div style="display: flex">
                                        <div class="col-md-1">
                                            <a href="{{ route('roles.index') }}"  type="button"
                                            class="btn btn-danger">Atras</a>
                                        </div>
                                        <div class="col-md-1">
                                            <input class="btn btn-primary" type="submit" value="Guardar">
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
            <!-- row -->

        </div>
        <!-- Container closed -->
    </div>
@endsection

@section('js-independiente')
    @include('layouts.js-fomularios')
@endsection
