@extends('layouts.app')
@section('contenido')
    <div class="main-content app-content">
        <!-- container -->
        <div class="main-container container-fluid">
            <!-- breadcrumb -->
            <div class="breadcrumb-header justify-content-between">
                <div class="left-content">
                    <span class="main-content-title mg-b-0 mg-b-lg-1">Notificaciones</span>
                </div>
                <div class="justify-content-center mt-2">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item tx-15"><a href="{{ url('home') }}">Inicio</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Notificaciones</li>
                    </ol>
                </div>
            </div>
            <!-- /breadcrumb -->
            <!-- row -->
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="row"
                                style="align-items: center;
                            justify-content: center;">
                                <h6 class="main-content-label mb-1">Listado de Notificaciones </h6>
                            </div>
                            <div class="table-responsive  export-table">
                                <table id="file-datatable"
                                    class="table table-bordered text-nowrap key-buttons border-bottom">
                                    <thead>
                                        <tr>
                                            <th class="border-bottom-0">id</th>
                                            <th class="border-bottom-0">Titulo</th>
                                            <th class="border-bottom-0">Fecha</th>
                                            <th class="border-bottom-0">Estado</th>
                                            <th class="border-bottom-0">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($notis as $noti)
                                            <tr>
                                                <td>{{ $noti->id }}</td>
                                                <td>
                                                    <a href="{{ url('/') . json_decode($noti->data)->link }}">
                                                        {{ explode('"', $noti->data)[3] }}
                                                        <br>
                                                        {{ explode('"', $noti->data)[7] }}
                                                    </a>
                                                </td>
                                                <td>
                                                    @php
                                                        $originalDate = $noti->created_at;
                                                        $newDate = date('d-m-Y H:i', strtotime($originalDate));
                                                    @endphp
                                                    {{ $newDate }}
                                                </td>
                                                <td>
                                                    @if ($noti->read_at !== null)
                                                        <span class="badge bg-success">Vista</span>
                                                    @else
                                                        <span class="badge bg-danger">Pendiente</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($noti->read_at == null)
                                                        @if ($noti->notifiable_id == auth()->user()->id)
                                                            <button title="Cambiar a vista"
                                                                class="btn btn-success waves-effect waves-light"
                                                                onclick="change_noti_read('{{ $noti->id }}');location.reload()">
                                                                <i class="bx bx-show-alt"
                                                                    style="font-size: 20px;"></i></button>
                                                        @endif
                                                    @else
                                                    <a href="{{ url('/') . json_decode($noti->data)->link}}">
                                                        <button title="Ver"
                                                        class="btn btn-success waves-effect waves-light"
                                                       >
                                                        <i class="bx bx-show-alt"
                                                            style="font-size: 20px;"></i></button>
                                                    </a>

                                                    @endif

                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- row -->
        </div>
        <!-- Container closed -->
    </div>
    <script>
        function deleteConfirm(id) {
            Swal.fire({
                title: "Seguro que desea ocultar este rol?",
                icon: "warning",
                showCancelButton: !0,
                confirmButtonColor: "#34c38f",
                cancelButtonColor: "#f46a6a",
                confirmButtonText: "Si"
            }).then((result) => {
                if (result.isConfirmed) {
                    $("#formDelete").attr('action', '{{ url('usuarios/') }}' + '/' + id);
                    $("#formDelete").submit();
                }
            });
        }
    </script>
@endsection
@section('js-independiente')
    @include('layouts.js-dattable')
@endsection
