<?php

namespace App\Notifications;

use App\Mail\TramiteCompletoMail;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;


class NewTramite extends Notification
{
    use Queueable;
  public $text;
  public $link;
  public $title;
  public  $mail;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(String $title,String $text,String $link,bool $mail)
    {
        $this->title = $title;
        $this->text = $text;
        $this->link = $link;
        $this->mail = $mail;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database','mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        if($this->mail){
           return new TramiteCompletoMail($this->title,$this->text,$this->link);
        }

    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'title'=>$this->title,
            'text'=>$this->text,
            'link'=>$this->link,
            'mail'=>$this->mail,
        ];
    }
}
