<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{

    use HasApiTokens, HasFactory, Notifiable, HasRoles, SoftDeletes;
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'apellido',
        'avatar',
        'password',
        'rcf',
        'calle',
        'no_ext',
        'no_int',
        'colonia',
        'municipio_delegacion',
        'localidad',
        'estado',
        'edad',
        'ocupacion',
        'estado_civil',
        'telefono',
        'celular',
        'numero_alterno',
        'nombre_beneficiario',
        'telefono_beneficiario',
         'token_fcm',
         'codigo_postal'

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getAvatar()
    {
        if ($this->avatar != null) {
            return $this->avatar;
        } else {
            return asset('assets/images/users/avatar-1.jpg');
        }
    }

    public function cursos(){
        return $this->belongsToMany('App\Models\Curso','cliente_curso','cliente_id','curso_id');
         }

}
