<?php

namespace App\Http\Controllers;

use App\Models\Libro;
use App\Models\Pagina;
use Illuminate\Http\Request;

class LibroController extends Controller


{

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $libros = Libro::all();
        return view('libro.index', get_defined_vars());
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $libro = new Libro();
        return view('libro.create', get_defined_vars());
    }

    public function deleteImg($id){
        $img = Pagina::find($id);
        if($img){
            $img->delete();
            return redirect()->back()->with('msg', 'Pagina Eliminada');
        }
        return redirect()->back()->with('error', 'No se ha encontrado la pagina');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        request()->validate(Libro::$rules);
        $input = $request->all();
        if($request->pdf){
            $pdf = $request->file('pdf');
                $pdf->storeAs('public/libros/', $pdf->getClientOriginalName());
                    $url = url('/') .'/storage/libros/'. ($pdf->getClientOriginalName());
                    $input['pdf'] = $url;

            }
        if($request->caratula){
            $img = $request->file('caratula');
                $img->storeAs('public/libros/', $img->getClientOriginalName());
                    $url = url('/') .'/storage/libros/'. ($img->getClientOriginalName());
                    $input['caratula'] = $url;

            }else{
                $input['caratula'] = asset('assets/img/logo.png');
            }
            $libro = Libro::create($input);
        if($request->imgs){
            $imgs = $request->file('imgs');
            foreach($imgs as $img){
                $img->storeAs('public/libros/' .$libro->id, $img->getClientOriginalName());
                    $url = url('/') .'/storage/libros/'.$libro->id.'/' . ($img->getClientOriginalName());
                    $img = new Pagina();
                    $img->url = $url;
                    $img->libro_id = $libro->id;
                    $img->save();
                }
            }

        return redirect()->route('libro.edit',$libro->id)
            ->with('msg', 'Libro Creado');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
       // $video = Video::find($id);
     //   return view('video.show', compact('video'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $libro = Libro::find($id);
        return view('libro.edit', get_defined_vars());
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  Ingreso $ingreso
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        request()->validate(Libro::$rules);
        $libro = Libro::find($id);
        $input = $request->all();
        if($request->caratula){
            $img = $request->file('caratula');
                $img->storeAs('public/libros/', $img->getClientOriginalName());
                    $url = url('/') .'/storage/libros/'. ($img->getClientOriginalName());
                    $input['caratula'] = $url;

            }
            if($request->pdf){
                $pdf = $request->file('pdf');
                    $pdf->storeAs('public/libros/', $pdf->getClientOriginalName());
                        $url = url('/') .'/storage/libros/'. ($pdf->getClientOriginalName());
                        $input['pdf'] = $url;

                }
        $libro->update($input);
        foreach($libro->paginas() as $pag){
            if($input['link'.$pag->id]){
                $pag->link = $input['link'.$pag->id];
                $pag->save();
            }
        }
        if($request->imgs){
            $imgs = $request->file('imgs');
            foreach($imgs as $img){
                $img->storeAs('public/libros/' .$libro->id, $img->getClientOriginalName());
                    $url = url('/') .'/storage/libros/'.$libro->id.'/' . ($img->getClientOriginalName());
                    $img = new Pagina();
                    $img->url = $url;
                    $img->libro_id = $libro->id;
                    $img->save();
                }
            }

        return redirect()->route('libro.index')
            ->with('msg', 'Libro Editado');
    }

    /**
     * @param int $id
     * @return \Illuminate\Http\RedirectResponse
     * @throws \Exception
     */
    public function destroy($id)
    {
        $video = Libro::find($id)->delete();

        return redirect()->route('libro.index')
            ->with('msg', 'Libro Eliminado');
    }
}

